(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     15061,        368]
NotebookOptionsPosition[     14742,        352]
NotebookOutlinePosition[     15086,        367]
CellTagsIndexPosition[     15043,        364]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "t"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "t"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"t", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", "0"}], "}"}]}], 
        "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t"}], ")"}], 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", "z"}], "}"}]}]}],
        ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Dashed", ",", "Black"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"t", 
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", "0"}], "}"}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Red", "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"t", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", "0"}], "}"}]}], 
        "+", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "z"}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Red", "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}], ",", " ", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}], ",", 
         "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Black", "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"\[Rho]", " ", "t", " ", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}], ",", " ", 
         RowBox[{"\[Rho]", " ", "t", " ", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], "/", "3"}]}], ",", 
         "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Blue", "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{"Cos", "[", "t", "]"}]}], ",", " ", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{"Sin", "[", "t", "]"}]}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Black", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", "z"}], "}"}], "+", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Cos", "[", "f", "]"}], 
            RowBox[{"Sin", "[", "t", "]"}]}], ",", 
           RowBox[{
            RowBox[{"Sin", "[", "f", "]"}], 
            RowBox[{"Sin", "[", "t", "]"}]}], ",", 
           RowBox[{"Cos", "[", "t", "]"}]}], "}"}], "/", "10"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Black", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"AxesOrigin", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", " ", 
    RowBox[{"\[Rho]", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", " ", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.571432998874667*^9, 3.5714331889545393`*^9}, {
   3.5714332243615646`*^9, 3.571433254372281*^9}, 3.571433290438344*^9, {
   3.571433378053355*^9, 3.571433421744854*^9}, {3.5714334824323254`*^9, 
   3.5714334959420977`*^9}, {3.5714335774977627`*^9, 3.571433594571739*^9}, {
   3.5714336576233454`*^9, 3.571433697960653*^9}, {3.571433741584148*^9, 
   3.5714337473284764`*^9}, {3.57143377956332*^9, 3.571433820356653*^9}, {
   3.5714339036004148`*^9, 3.571433954260312*^9}, 3.571434241629749*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`z$$ = 0, $CellContext`\[Rho]$$ = 
    0, $CellContext`\[CurlyPhi]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Rho]$$], 0, 8}, {
      Hold[$CellContext`\[CurlyPhi]$$], 0, 2 Pi}, {
      Hold[$CellContext`z$$], 0, 5}}, Typeset`size$$ = {360., {169., 172.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Rho]$14971$$ = 0, $CellContext`\[CurlyPhi]$14972$$ = 
    0, $CellContext`z$14973$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`z$$ = 0, $CellContext`\[Rho]$$ = 
        0, $CellContext`\[CurlyPhi]$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`\[Rho]$$, $CellContext`\[Rho]$14971$$, 0], 
        Hold[$CellContext`\[CurlyPhi]$$, $CellContext`\[CurlyPhi]$14972$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$14973$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[{
         ParametricPlot3D[{$CellContext`t, 0, 0}, {$CellContext`t, 0, 10}, 
          PlotStyle -> Thick], 
         ParametricPlot3D[{$CellContext`t, 0, 0}, {$CellContext`t, -10, 0}, 
          PlotStyle -> {Thick, Dashed}], 
         ParametricPlot3D[{0, $CellContext`t, 0}, {$CellContext`t, 0, 10}, 
          PlotStyle -> Thick], 
         ParametricPlot3D[{0, $CellContext`t, 0}, {$CellContext`t, -10, 0}, 
          PlotStyle -> {Thick, Dashed}], 
         ParametricPlot3D[{0, 0, $CellContext`t}, {$CellContext`t, 0, 10}, 
          PlotStyle -> Thick], 
         ParametricPlot3D[{0, 0, $CellContext`t}, {$CellContext`t, -10, 0}, 
          PlotStyle -> {Thick, Dashed}]}, 
        ParametricPlot3D[$CellContext`t {$CellContext`\[Rho]$$ 
            Cos[$CellContext`\[CurlyPhi]$$], $CellContext`\[Rho]$$ 
            Sin[$CellContext`\[CurlyPhi]$$], 0} + (
           1 - $CellContext`t) {$CellContext`\[Rho]$$ 
            Cos[$CellContext`\[CurlyPhi]$$], $CellContext`\[Rho]$$ 
            Sin[$CellContext`\[CurlyPhi]$$], $CellContext`z$$}, \
{$CellContext`t, 0, 1}, PlotStyle -> {Dashed, Black}], 
        ParametricPlot3D[$CellContext`t {$CellContext`\[Rho]$$ 
           Cos[$CellContext`\[CurlyPhi]$$], $CellContext`\[Rho]$$ 
           Sin[$CellContext`\[CurlyPhi]$$], 0}, {$CellContext`t, 0, 1}, 
         PlotStyle -> {Red}], 
        ParametricPlot3D[$CellContext`t {$CellContext`\[Rho]$$ 
            Cos[$CellContext`\[CurlyPhi]$$], $CellContext`\[Rho]$$ 
            Sin[$CellContext`\[CurlyPhi]$$], 0} + {
          0, 0, $CellContext`z$$}, {$CellContext`t, 0, 1}, 
         PlotStyle -> {Red}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ (
           Cos[$CellContext`f $CellContext`\[CurlyPhi]$$]/
           3), $CellContext`\[Rho]$$ (
           Sin[$CellContext`f $CellContext`\[CurlyPhi]$$]/3), 
          0}, {$CellContext`f, 0, 1}, PlotStyle -> {Black}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ $CellContext`t (
           Cos[$CellContext`f $CellContext`\[CurlyPhi]$$]/
           3), $CellContext`\[Rho]$$ $CellContext`t (
           Sin[$CellContext`f $CellContext`\[CurlyPhi]$$]/3), 
          0}, {$CellContext`t, 0, 1}, {$CellContext`f, 0, 1}, 
         PlotStyle -> {Blue}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ 
          Cos[$CellContext`t], $CellContext`\[Rho]$$ Sin[$CellContext`t], 
          0}, {$CellContext`t, 0, 2 Pi}, PlotStyle -> {Black, Dashed}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ 
           Cos[$CellContext`\[CurlyPhi]$$], $CellContext`\[Rho]$$ 
           Sin[$CellContext`\[CurlyPhi]$$], $CellContext`z$$} + {
           Cos[$CellContext`f] Sin[$CellContext`t], Sin[$CellContext`f] 
            Sin[$CellContext`t], 
            Cos[$CellContext`t]}/10, {$CellContext`f, 0, 2 
          Pi}, {$CellContext`t, 0, Pi}, PlotStyle -> {Black, Thick}], 
        PlotRange -> {{-8, 8}, {-8, 8}, {-3, 8}}, Boxed -> False, Axes -> 
        False, AxesOrigin -> {0, 0}], 
      "Specifications" :> {{$CellContext`\[Rho]$$, 0, 
         8}, {$CellContext`\[CurlyPhi]$$, 0, 2 Pi}, {$CellContext`z$$, 0, 5}},
       "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{409., {241., 246.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.5714330901108856`*^9, 3.571433114608287*^9}, {
   3.571433163384077*^9, 3.571433189585575*^9}, {3.5714332283337917`*^9, 
   3.571433256580407*^9}, 3.571433291617411*^9, {3.5714333791604185`*^9, 
   3.5714334227839136`*^9}, {3.5714334842204275`*^9, 
   3.5714335104569283`*^9}, {3.571433578463818*^9, 3.571433595022765*^9}, {
   3.5714336583743887`*^9, 3.571433698895706*^9}, 3.571433747615493*^9, 
   3.5714338209646883`*^9, {3.5714339045394683`*^9, 3.571433922695507*^9}, 
   3.5714339550823593`*^9, 3.571434243382849*^9, 3.571435478660503*^9}]
}, Open  ]]
},
WindowSize->{1904, 945},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 8660, 228, 212, "Input"],
Cell[9242, 252, 5484, 97, 504, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
